<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Faker\Factory as Faker;

class CustomerSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Common Ethiopian names
        $maleNames = ['Abebe', 'Alemu', 'Bekele', 'Teshome', 'Meles', 'Solomon', 'Yohannes', 'Kebede', 'Birhanu', 'Getachew'];
        $femaleNames = ['Tigist', 'Mulu', 'Lensa', 'Hiwot', 'Genet', 'Saba', 'Selam', 'Mekdes', 'Tsion', 'Rahel'];
        $lastNames = ['Gebre', 'Hailu', 'Mengistu', 'Asfaw', 'Wolde', 'Tadesse', 'Demissie', 'Gebremariam'];

        $cities = ['Addis Ababa', 'Bahir Dar', 'Gondar', 'Hawassa', 'Mekelle', 'Adama', 'Jimma'];
        $regions = ['Addis Ababa', 'Oromia', 'Amhara', 'Tigray', 'SNNPR', 'Sidama'];
        $languages = ['am', 'om', 'ti', 'en'];
        $occupations = ['Farmer', 'Teacher', 'Engineer', 'Doctor', 'Trader', 'Driver', 'Government Worker'];
        $sources = ['walk-in', 'website', 'agent', 'referral'];

        for ($i = 0; $i < 1000; $i++) {
            $gender = $faker->randomElement(['male', 'female']);
            $firstName = $gender == 'male' ? $faker->randomElement($maleNames) : $faker->randomElement($femaleNames);
            $middleName = rand(0, 1) ? $faker->randomElement(array_merge($maleNames, $femaleNames)) : null;
            $lastName = $faker->randomElement($lastNames);

            $createdAt = $faker->dateTimeBetween('2024-01-01', now());

            DB::table('customers')->insert([
                'first_name' => $firstName,
                'middle_name' => $middleName,
                'last_name' => $lastName,
                'gender' => $gender,
                'date_of_birth' => $faker->dateTimeBetween('-60 years', '-18 years')->format('Y-m-d'),
                'place_of_birth' => $faker->randomElement($cities),
                'marital_status' => $faker->randomElement(['single', 'married', 'divorced', 'widowed']),
                'nationality' => 'ET',
                'national_id' => $faker->unique()->numerify('#######'),
                'passport_number' => $faker->unique()->bothify('EP########'),
                'tax_id' => $faker->unique()->numerify('############'),
                'email' => $faker->unique()->safeEmail,
                'phone' => '+2519' . $faker->numerify('########'),
                'alt_phone' => rand(0, 1) ? '+2519' . $faker->numerify('########') : null,
                'email_verified_at' => rand(0, 1) ? now() : null,
                'phone_verified_at' => rand(0, 1) ? now() : null,
                'address' => $faker->streetAddress,
                'city' => $faker->randomElement($cities),
                'state' => $faker->randomElement($regions),
                'country' => 'Ethiopia',
                'postal_code' => $faker->numerify('####'),
                'occupation' => $faker->randomElement($occupations),
                'employer_name' => rand(0, 1) ? $faker->company : null,
                'employer_address' => rand(0, 1) ? $faker->address : null,
                'employment_status' => $faker->randomElement(['employed', 'unemployed', 'self-employed', 'retired']),
                'annual_income' => $faker->randomFloat(2, 10000, 500000),
                'profile_picture' => $faker->imageUrl(200, 200, 'people'),
                'customer_status' => $faker->randomElement(['active', 'inactive', 'blacklisted']),
                'notes' => rand(0, 1) ? $faker->sentence : null,
                'source' => $faker->randomElement($sources),
                'password' => Hash::make('password'),
                'last_login_at' => $faker->dateTimeBetween('-6 months', 'now'),
                'created_by' => 1,
                'updated_by' => 1,
                'preferred_contact_method' => $faker->randomElement(['email', 'phone', 'sms', 'telegram']),
                'allow_marketing_emails' => $faker->boolean,
                'allow_sms_notifications' => $faker->boolean,
                'allow_push_notifications' => $faker->boolean,
                'language_preference' => $faker->randomElement($languages),
                'timezone' => 'Africa/Addis_Ababa',
                'created_at' => $createdAt,
                'updated_at' => $createdAt,
                'deleted_at' => null,
            ]);
        }
    }
}
